% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GctMatrix.R
\name{cbindGct}
\alias{cbindGct}
\title{Column bind (cbind) two GctMatrix objects}
\usage{
cbindGct(
  gctMatrix1,
  gctMatrix2,
  feature = c("union", "intersection"),
  missingValue = 0
)
}
\arguments{
\item{gctMatrix1}{The first object}

\item{gctMatrix2}{The second object}

\item{feature}{What happens if the set of the features in both objects differ? Either union or intersection is possible.}

\item{missingValue}{Missing values, \code{NA} or numeric values (such as 0) are accepted}
}
\value{
A larger matrix, with gctMatrix1 on the left and gctMatrix2 on the right, with merged features and descriptions.
}
\description{
Column bind (cbind) two GctMatrix objects
}
\examples{
m1 <- matrix(1:6, nrow=3, dimnames=list(sprintf("G\%d", 1:3), sprintf("S\%d", 1:2)))
m2 <- matrix(c(9:7, 12:10), nrow=3, dimnames=list(sprintf("G\%d", 3:1), sprintf("S\%d", 3:4)))
gm1 <- GctMatrix(m1, desc=sprintf("Gene\%d", 1:3))
gm2 <- GctMatrix(m2, desc=sprintf("Gene\%d", 3:1))
gm1
gm2
gm12 <- cbindGct(gm1, gm2)
gm12
m3 <- matrix(13:18, nrow=3, dimnames=list(sprintf("G\%d", 2:4), sprintf("S\%d", 5:6)))
gm3 <- GctMatrix(m3, desc=sprintf("Gene\%d", 2:4))
gm3
gm123Intersect <- cbindGct(gm12, gm3, feature="intersect")
print(gm123Intersect, showAll=TRUE)
gm123Union <- cbindGct(gm12, gm3, feature="union")
print(gm123Union, showAll=TRUE)
gm123UnionNA <- cbindGct(gm12, gm3, feature="union", missingValue = NA)
print(gm123UnionNA)
}
