% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cut_directions}
\alias{cut_directions}
\title{Directional binning}
\usage{
cut_directions(directions, n_bins = 8, labels = NULL)
}
\arguments{
\item{directions}{vector of directions to be binned, in degree, 0° being the North.}

\item{n_bins}{number of bins, default: 8 sectors.}

\item{labels}{optional character vector giving the sectors names.}
}
\value{
a factor vector the same size as \code{directions} with the values binned into sectors.
}
\description{
Cuts direction vector into directional bins
}
\examples{
# Example usage and demonstration
set.seed(123)
directions <- runif(20, 0, 360)

# Test with different numbers of bins
cat("Original directions:\n")
print(round(directions, 1))

cat("\n8 bins (default):\n")
bins_8 <- cut_directions(directions, n_bins = 8)
print(bins_8)

cat("\n4 bins:\n")
bins_4 <- cut_directions(directions, n_bins = 4)
print(bins_4)
}
