% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remify.R
\name{getTypeName}
\alias{getTypeName}
\alias{getTypeName.remify}
\title{getTypeName}
\usage{
getTypeName(x, typeID = NULL)

\method{getTypeName}{remify}(x, typeID = NULL)
}
\arguments{
\item{x}{a \code{remify} object.}

\item{typeID}{a vector of type ID's. The ID value can range between \code{1} and \code{C} (number of event types in the network).}
}
\value{
character vector of types' names.
}
\description{
A function that given a vector of type ID's returns the corresponding vector of type (input) names.
}
\section{Methods (by class)}{
\itemize{
\item \code{getTypeName(remify)}: return type's name from type's ID

}}
\examples{

# processing the random network 'randomREH'
library(remify)
data(randomREH)
reh <- remify(edgelist = randomREH$edgelist,
              model = "tie",
              riskset = "manual",
              omit_dyad = randomREH$omit_dyad)

# find type name from type ID
getTypeName(x = reh, typeID = c(1,3))

}
