% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survaalen.R
\name{survaalen}
\alias{survaalen}
\title{Fit an additive hazards model}
\usage{
survaalen(formula, data, variance = FALSE, var_estimator = "dN", add.times)
}
\arguments{
\item{formula}{a formula object, with the response as a \code{Surv} object
on the left of a \code{~} operator, and, if desired, terms separated by the
\code{+} operator on the right.}

\item{data}{a data.frame in which to interpret the variables named in the
\code{formula}.}

\item{variance}{a logical value indicating whether the variances of the hazards should be computed.
Default is FALSE.}

\item{var_estimator}{Choose variance estimator. The default option 'dN' uses dN(t) in the variance formula, see formula 4.63 in Aalen et al. (2008). Option 'XdB' uses X*dB(t), see formula 4.64 in Aalen et al. (2008).}

\item{add.times}{specific times at which estimates should be obtained.}
}
\value{
An object of class \code{aalen.model}.
}
\description{
Fits the Aalen additive hazard model. The function can be used for multi-state model
data (as in the package mstate; class msdata) by supplying the start and stop times in the
Surv object and adding a strata(trans) object in the formula (where trans denotes the
transition in the multi-state model).
}
\examples{

# Survival:
data(rdata)
mod <- survaalen(Surv(time, cens)~sex+age, data=rdata)
head(mod$coefficients)
tail(mod$coefficients)

# Multi-state model:
data(ebmt1wide)
mod <- survaalen(Surv(Tstart, Tstop, status)~age.1+age.2+age.3+strata(trans), data=ebmt1wide)
head(mod$coefficients$trans1)
head(mod$coefficients$trans2)
head(mod$coefficients$trans3)
}
\seealso{
\code{\link{rsaalen}}
}
\author{
Damjan Manevski
}
\keyword{survival}
