% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilsRIVerification.R
\name{perc_ci_asymptotic}
\alias{perc_ci_asymptotic}
\title{Function to approximate the sampling uncertainty of quantiles using the asymptotic method}
\usage{
perc_ci_asymptotic(mu, sigma, n, prob, conf.level)
}
\arguments{
\item{mu}{(numeric) mean of the distribution}

\item{sigma}{(numeric) standard deviation of the distribution}

\item{n}{(numeric) integer value indicating the sample size}

\item{prob}{(numeric) quantile value(s) for which to calculate the confidence interval(s)}

\item{conf.level}{(numeric) confidence level for the interval(s)}
}
\value{
(matrix) of confidence interval(s) of quantiles of the normal distribution
}
\description{
Function to approximate the sampling uncertainty of quantiles using the asymptotic method
}
\examples{
\dontrun{
perc_ci_asymptotic(mu = 0, sigma = 1, n = 120, prob = c(0.025, 0.975), conf.level = 0.9)
}

}
\references{
Serfling RJ. Approximation theorems of mathematical statistics. NY: John Wiley & Sons; 1980:121 p.
}
\author{
Florian Dufey \email{florian.dufey@roche.com}
}
