% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_NCBI.R
\name{refdb_import_NCBI}
\alias{refdb_import_NCBI}
\title{Download and import NCBI Nucleotide records}
\usage{
refdb_import_NCBI(
  query,
  full = FALSE,
  max_seq_length = 10000,
  seq_bin = 200,
  verbose = TRUE,
  start = 0L
)
}
\arguments{
\item{query}{a character string with the query.}

\item{full}{a logical. If FALSE (the default), only a subset of
the most important fields is included in the result.}

\item{max_seq_length}{a numeric giving the maximum length of sequences
to retrieve. Useful to exclude complete genomes.}

\item{seq_bin}{number of sequences to download at once.}

\item{verbose}{print information in the console.}

\item{start}{an integer giving the index where to start to download.
For debugging purpose mainly.}
}
\value{
A tibble.
}
\description{
This function allows to search and download data
from the the NCBI Nucleotide database.
Additionally it uses the NCBI Taxonomy database
to get the sequence taxonomic classification.
}
\details{
This function uses several functions of the \pkg{rentrez}
package to interface with the NCBI's EUtils API.*
}
\section{Errors}{

\code{Error in curl::curl_fetch_memory(url, handle = handle) :
transfer closed with outstanding read data remaining} \cr
This error seems to appear with long sequences.
You can try to decrease \code{max_seq_length} to exclude them.
}

\examples{
\donttest{
try(silo_ncbi <- refdb_import_NCBI("Silo COI"))
}

}
