% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segregation.R
\name{seg_dissim}
\alias{seg_dissim}
\title{Compute Dissimilarity Index}
\usage{
seg_dissim(plans, shp, group_pop, total_pop)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame containing other columns.}

\item{group_pop}{Unqouted name of column in \code{shp} with group population.}

\item{total_pop}{Unqouted name of column in \code{shp} with total population.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Compute Dissimilarity Index
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
seg_dissim(plans = nh$r_2020, shp = nh, group_pop = vap_hisp, total_pop = vap)

# Or many plans:
seg_dissim(plans = nh_m[, 3:5], shp = nh, group_pop = vap_hisp, total_pop = vap)

}
\references{
Douglas Massey and Nancy Denton. 1987.
The Dimensions of Social Segregation. Social Forces.
}
\concept{segregation}
