% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_abs_livestock_data.R
\name{read_abs_livestock_data}
\alias{read_abs_livestock_data}
\title{Read ABS' Livestock Production and Value by Australia, State and Territory by Year}
\usage{
read_abs_livestock_data(data_set = "livestock_and_products", x = NULL)
}
\arguments{
\item{data_set}{A string value providing the desired livestock data, one of:
\describe{
\item{livestock_and_products}{(default) value of livestock disposals and products by Australia, state and territory,}
\item{cattle_herd}{Cattle herd experimental estimates by Australia, state and territory,}
\item{cattle_herd_series}{Cattle herd experimental and historical estimates by Australia, state and territory – 2005 to 2024.}
}}

\item{x}{A file path providing the file with the data to be imported. The
file is assumed to be unarchived (\emph{i.e.}, still zipped). This function does
not provide any checking whether this function is the proper function for
the provided file.  Defaults to \code{NULL}, assuming that the file will be
downloaded in the active \R session.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} object of the requested data.
}
\description{
Automates downloading and importing of \acronym{ABS} livestock production
data. Please view the comments embedded in the spreadsheets themselves (that
really should be columns of comments on the data) for important information.
}
\details{
Technically these data are from the Australian Bureau of Statistics
(\acronym{ABS}, not \acronym{ABARES}, but the data is agricultural and so
it's serviced in this package.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
livestock_data <- read_abs_livestock_data()

livestock_data
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.abs.gov.au/statistics/industry/agriculture/australian-agriculture-livestock}.
}
\seealso{
Other ABS: 
\code{\link{read_abs_broadacre_data}()},
\code{\link{read_abs_horticulture_data}()}
}
\concept{ABS}
