% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_finturk.R
\name{fetch_finturk1}
\alias{fetch_finturk1}
\title{Fetch Quarterly Data from BDDK FinTurk with Multiple Provinces}
\usage{
fetch_finturk1(year, month, table_no, grup_kod = 10001, il = 0)
}
\arguments{
\item{year}{Year as 4-digit integer (YYYY).}

\item{month}{Month as integer (3,6,9,12 for quarterly data).}

\item{table_no}{Table number to fetch (1-7). No default.}

\item{grup_kod}{Group code (10001-1007). Default 10001.}

\item{il}{plaka (license plate) number (0-81); 999 = Yurt Disi. Default 0.
0=HEPSI (All Cities), 1=Adana, 6=Ankara, 34=Istanbul, 35=Izmir, etc.
See \code{\link{list_cities}} for full list.}
}
\value{
Data frame with a \code{fetch_info} attribute that contains query details.
}
\description{
Retrieves quarterly banking data from the BDDK FinTurk API for specified
group codes and provinces. Supports multiple group codes and province
codes in a single request.
}
\details{
The FinTurk API only provides data for quarter-ending months (March, June,
September, December). Province codes follow Turkey's standard license
plate numbering (1 = Adana, 6 = Ankara, 34 = Istanbul, etc.).
}
\examples{
# Single group, all provinces
fetch_finturk1(2020, 3, 1, grup_kod = 10001)

# Multiple groups and specific provinces
fetch_finturk1(2020, 3, 1, grup_kod = c(10006, 10007), il = c(6, 34))

# Single group, single province
fetch_finturk1(2020, 3, 1, grup_kod = 10001, il = 34)

}
\seealso{
\code{\link[=fetch_bddk1]{fetch_bddk1()}} for monthly data without province granularity.
}
