#' Getting Started with rblimp
#'
#' @description
#' A guide to installing and configuring Blimp software for use with rblimp.
#'
#' @section Installing Blimp Software:
#'
#' Before using rblimp, you must install the Blimp software (freely available):
#' \enumerate{
#'   \item Visit \url{https://www.appliedmissingdata.com/blimp}
#'   \item Download the version for your operating system
#'   \item Follow the installation instructions
#' }
#'
#' After installation, configure Blimp. The package will look for Blimp in the
#' following order:
#' \enumerate{
#'   \item The \code{R_BLIMP} environment variable
#'   \item Common installation locations (automatic detection)
#' }
#'
#' To configure Blimp:
#' \preformatted{
#' # Automatic detection
#' detect_blimp()
#'
#' # Or set path manually (for current session)
#' set_blimp("/path/to/blimp")
#'
#' # Or set R_BLIMP environment variable (permanent)
#' # Add to .Renviron file:
#' # R_BLIMP="/path/to/blimp"
#'
#' # Verify installation
#' has_blimp()
#' }
#'
#' @section Automatic Update Checks:
#'
#' By default, rblimp automatically checks for Blimp updates when you run models.
#' This ensures you're using the latest version with bug fixes and improvements.
#'
#' To disable automatic update checks:
#' \preformatted{
#' # Disable for current session
#' options(check_blimp_update = FALSE)
#'
#' # Or add to .Rprofile for permanent setting:
#' # options(check_blimp_update = FALSE)
#' }
#'
#' You can manually check for updates at any time:
#' \preformatted{
#' update_blimp()
#' }
#'
#' @section Function Reference:
#'
#' **Model Fitting:**
#' \itemize{
#'   \item \code{\link{rblimp}} - Fit Bayesian models
#'   \item \code{\link{rblimp_fcs}} - Fully Conditional Specification imputation
#'   \item \code{\link{rblimp_syntax}} - Generate Blimp syntax
#'   \item \code{\link{rblimp_source}} - Run existing Blimp syntax files
#' }
#'
#' **Simulation:**
#' \itemize{
#'   \item \code{\link{rblimp_sim}} - Generate simulated datasets
#'   \item \code{\link{SIMULATE}} - Create simulation specifications
#' }
#'
#' **Output & Analysis:**
#' \itemize{
#'   \item \code{\link[=summary,blimp_obj-method]{summary}} - Model summary
#'   \item \code{\link{estimates}} - Extract parameter estimates
#'   \item \code{\link{describe}} - Descriptive statistics
#'   \item \code{\link{psr}} - Potential Scale Reduction values
#'   \item \code{\link{output}} - Raw Blimp output
#'   \item \code{\link{standardized}} - Extract standardized parameters only
#'   \item \code{\link{compare}} - Compare models
#' }
#'
#' **Visualization:**
#' \itemize{
#'   \item \code{\link{trace_plot}} - MCMC trace plots
#'   \item \code{\link{posterior_plot}} - Posterior density plots
#'   \item \code{\link{residual_plot}} - Residual diagnostics
#'   \item \code{\link{jn_plot}} - Johnson-Neyman plots
#'   \item \code{\link{simple_plot}} - Simple slopes plots
#'   \item \code{\link{model_table}} - Publication tables
#' }
#'
#' **Utilities:**
#' \itemize{
#'   \item \code{\link{by_group}} - Grouped analysis
#'   \item \code{\link{as.mitml}} - Convert to mitml format
#'   \item \code{\link[=names,blimp_obj-method]{names}} - Obtain imputation variable names
#'   \item \code{\link[=with,blimp_obj-method]{with}} - Evaluate across imputations
#'   \item \code{\link{write.blimp}} - Write results to files
#' }
#'
#' **Setup & Configuration:**
#' \itemize{
#'   \item \code{\link{detect_blimp}} - Detect Blimp installation
#'   \item \code{\link{set_blimp}} - Set path to Blimp executable
#'   \item \code{\link{has_blimp}} - Check if Blimp is available
#'   \item \code{\link{update_blimp}} - Update Blimp installation
#' }
#'
#' @section Additional Resources:
#' \itemize{
#'   \item GitHub repository: \url{https://github.com/blimp-stats/rblimp}
#'   \item Example files: \url{https://github.com/blimp-stats/rblimp-examples}
#'   \item Blimp User Guide: \url{https://docs.google.com/document/d/1D3MS79CakuX9mVVvGH13B5nRd9XLttp69oGsvrIRK64}
#'   \item Report issues: \url{https://github.com/blimp-stats/rblimp/issues}
#' }
#'
#' @name rblimp_getting_started
#' @keywords documentation
NULL
