% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-freidlin-wentzell.R
\name{fitflow_FW}
\alias{fitflow_FW}
\title{Fit Flow Using Freidlin-Wentzell Quasi-Potential}
\usage{
fitflow_FW(
  observed,
  states = NULL,
  flowtype = "maf",
  flowspec = list(),
  inittheta = NULL,
  drift,
  x0,
  x1,
  T = 200,
  dt = 0.01,
  eps = 0.1,
  nmc = 256,
  control = list()
)
}
\arguments{
\item{observed}{Empirical distribution Q.}

\item{states}{Optional category names.}

\item{flowtype}{Flow type.}

\item{flowspec}{Structural parameters for the flow.}

\item{inittheta}{Optional initial theta.}

\item{drift}{Drift function \eqn{b(x)}.}

\item{x0}{Starting point.}

\item{x1}{Target point.}

\item{T}{Number of time steps.}

\item{dt}{Time step.}

\item{eps}{Noise strength (small parameter).}

\item{nmc}{Monte Carlo samples.}

\item{control}{Control list for \code{optim()}.}
}
\value{
Output of \code{fitflowvariational()}.
}
\description{
Computes the Freidlin-Wentzell quasi-potential between \eqn{x_0} and \eqn{x_1},
constructs a tilted likelihood proportional to \eqn{\exp(-V/\mathrm{eps})},
and fits a flow-based variational posterior.
}
\details{
This is useful for rare-event inference in small-noise diffusions,
where the quasi-potential acts as an effective energy landscape.
}
