% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/friedlin-wentzell.R
\name{FW_quasipotential}
\alias{FW_quasipotential}
\title{Freidlin-Wentzell Quasi-Potential via Path Minimization}
\usage{
FW_quasipotential(
  x0,
  x1,
  drift,
  T = 200,
  dt = 0.01,
  niter = 200,
  stepsize = 0.1
)
}
\arguments{
\item{x0}{Starting point (numeric vector).}

\item{x1}{Target point (numeric vector).}

\item{drift}{Drift function \eqn{b(x)}.}

\item{T}{Number of time steps.}

\item{dt}{Time step.}

\item{niter}{Number of gradient descent iterations.}

\item{stepsize}{Gradient descent step size.}
}
\value{
A list with:
\itemize{
  \item path: matrix of size \eqn{T \times d}
  \item action: FW action of the optimized path
}
}
\description{
Computes an approximate Freidlin-Wentzell quasi-potential between two
points \eqn{x_0} and \eqn{x_1} by minimizing the FW action functional
over discretized paths.
}
\details{
The algorithm:
\enumerate{
  \item Initializes a straight-line path between \eqn{x_0} and \eqn{x_1}.
  \item Performs simple gradient descent on the FW action.
}

This is a naive but effective illustrative method for low-dimensional
systems. More advanced solvers (string method, MAM, etc.) can be plugged in.
}
