% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_activity.R
\name{get_activity}
\alias{get_activity}
\title{Get detailed data of an activity}
\usage{
get_activity(id, stoken)
}
\arguments{
\item{id}{character vector for id of the activity}

\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}
}
\value{
Data from an API request.
}
\description{
Get detailed data of an activity, including segment efforts
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.

The id for each activity can be viewed using results from \code{\link{get_activity_list}}.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

get_activity('75861631', stoken)
}
}
\concept{token}
