% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifting_scheme.R
\name{lift_step}
\alias{lift_step}
\title{Create an individual Lifting Step}
\usage{
lift_step(
  type = c("predict", "update"),
  coeffs,
  start_idx = NULL,
  position = "center"
)
}
\arguments{
\item{type}{Step type: "predict" (P) or "update" (U).}

\item{coeffs}{Numeric vector containing the filter coefficients.}

\item{start_idx}{(Optional) Manual start index. If provided, ignores the
\code{position} parameter. Use this for fine-grained control.}

\item{position}{Automatic index adjustment
(used only if \code{start_idx} is NULL):
\itemize{
\item "center": Centers the filter (default).
\item "left": Causal filter (looks into the past).
\item "right": Anti-causal filter (looks into the future).
}}
}
\value{
A list formatted for the internal lifting engine.
}
\description{
Helper function to create prediction (P) or update (U) steps,
abstracting the complexity of index management.
}
