% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rCoinBase.R
\name{cb_create_convert_quote}
\alias{cb_create_convert_quote}
\title{Create Convert Quote}
\usage{
cb_create_convert_quote(amount, from_account, to_account)
}
\arguments{
\item{amount}{= The ID of the trade to commit.}

\item{from_account}{= The currency of the account to convert from (e.g. USD).}

\item{to_account}{= The currency of the account to convert to (e.g. USDC).}
}
\value{
A \code{data.frame} with details regarding creating a convert quote with a specified source account,target account, and amount. Convert is applicable for USDC-USD, EURC-EUR, and PYUSD-USD conversion
}
\description{
Create Convert Quote
}
\examples{
\dontrun{
  qte = cb_create_convert_quote(amount = 100,
                                from_account = "USD",
                                to_account = "USDC")
  ord = cb_commit_convert_trade(trade_id = qte$id,
                                from_account = "USD",
                                to_account = "USDC")
 stat = cb_get_convert_trade(trade_id = qte$id,
                             from_account = "USD",
                             to_account = "USDC")
}
}
