% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{codebook}
\alias{codebook}
\title{Extract codebook from quallmer objects}
\usage{
codebook(x)
}
\arguments{
\item{x}{A quallmer object (\code{qlm_coded}, \code{qlm_comparison}, or \code{qlm_validation}).}
}
\value{
A \code{qlm_codebook} object, or \code{NULL} if no codebook is available.
}
\description{
Extracts the codebook component from \code{qlm_coded}, \code{qlm_comparison}, and
\code{qlm_validation} objects. The codebook is a constitutive part of the coding
run, defining the coding instrument used.
}
\details{
The codebook is a core component of coded objects, analogous to \code{formula()}
for \code{lm} objects. It specifies the coding instrument (instructions, schema,
role) used in the coding run.

This function is an extractor for the codebook component, not a metadata
accessor. For codebook metadata (name, instructions), use \code{\link[=qlm_meta]{qlm_meta()}}.

Note: \code{qlm_codebook()} is the constructor for creating codebooks; \code{codebook()}
is the extractor for retrieving them from coded objects.
}
\examples{
# Load example objects
examples <- readRDS(system.file("extdata", "example_objects.rds", package = "quallmer"))
coded <- examples$example_coded_sentiment

# Extract codebook
cb <- codebook(coded)
cb

# Access codebook metadata
qlm_meta(cb, "name")

}
\seealso{
\itemize{
\item \link{accessors} for an overview of the accessor function system
\item \code{\link[=qlm_codebook]{qlm_codebook()}} for creating codebooks
\item \code{\link[=qlm_meta]{qlm_meta()}} for extracting metadata
\item \code{\link[=inputs]{inputs()}} for extracting input data
}
}
