% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcpp_calc_Bhat.R
\name{rcpp_calc_Bhat}
\alias{rcpp_calc_Bhat}
\title{Estimate allele effects matrix, B hat, with Rcpp functions}
\usage{
rcpp_calc_Bhat(X, Sigma_inv, Y)
}
\arguments{
\item{X}{dn by df block-diagonal design matrix that incorporates genetic info for two markers. Note that we can use the same marker data twice.}

\item{Sigma_inv}{dn by dn inverse covariance matrix, where its inverse, ie, Sigma, is often composed as \eqn{K \otimes V_g + I_n \otimes V_e}}

\item{Y}{dn by 1 matrix, ie, a column vector, of d phenotypes' measurements}
}
\value{
a df by 1 matrix of GLS-estimated allele effects
}
\description{
Estimate allele effects matrix, B hat, with Rcpp functions
}
\examples{
X1 <- as.matrix(rbinom(n = 100, size = 1, prob = 1 / 2))
X <- gemma2::stagger_mats(X1, X1)
Sigma_inv <- diag(200)
Y <- runif(200)
rcpp_calc_Bhat(X = X, Sigma_inv = Sigma_inv, Y = Y)
}
