% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_records.R
\name{get_records}
\alias{get_records}
\title{Retrieve Data from 'NLM'/'PubMed' databases Based on PMIDs}
\usage{
get_records(
  pmids,
  endpoint = c("pubtations", "icites", "pubmed_affiliations", "pubmed_references",
    "pubmed_abstracts", "pmc_fulltext"),
  cores = 3,
  sleep = 1,
  ncbi_key = NULL
)
}
\arguments{
\item{pmids}{A vector of PMIDs for which data is to be retrieved. For 'pmc_fulltext' endpoint, 
provide full URLs instead (e.g., from \code{pmid_to_pmc()$url}).}

\item{endpoint}{A character vector specifying the type of data to retrieve ('pubtations', 'icites', 
'pubmed_affiliations', 'pubmed_references', 'pubmed_abstracts', 'pmc_fulltext').}

\item{cores}{Number of cores to use for parallel processing (default is 3).}

\item{sleep}{Duration (in seconds) to pause after each batch}

\item{ncbi_key}{(Optional) NCBI API key for authenticated access.}
}
\value{
A data.table containing combined results from the specified endpoint.
}
\description{
This function retrieves different types of data (like 'PubMed' records, affiliations, 'iCites 'data, etc.) from 'PubMed' based on provided PMIDs. It supports parallel processing for efficiency.
}
\details{
For the 'pmc_fulltext' endpoint, provide full URLs to PMC tar.gz files. 
Use \code{\link{pmid_to_pmc}} to convert PMIDs to PMC IDs and full URLs first.
}
\examples{
pmids <- c("38136652")
results <- get_records(pmids, endpoint = "pubmed_abstracts", cores = 1)

}
