% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot_alphabeta.R
\name{.beta}
\alias{.beta}
\title{Calculate Beta Irreplaceability}
\usage{
.beta(alphas, na.rm = FALSE)
}
\arguments{
\item{alphas}{vector - A vector of numbers between 0-1.}

\item{na.rm}{logical - Should missing values (NA) be removed?}
}
\value{
A number between 0 and 1.
}
\description{
This function calculates Beta Irreplaceability from a vector of Alpha
Irreplaceability values. Alpha Irreplaceability values can be calculated using
\code{\link{.alpha}()}.
}
\examples{
.beta(alphas=c(0.1,0.32,0.5))
.beta(alphas=c(0.1,0.32,0.9))
.beta(alphas=c(0.1,0.32,1))
.beta(alphas=c(0.1,0.32,NA), na.rm=TRUE)
}
\references{
\doi{10.1111/cobi.13806}
}
\author{
Daniele Baisero, \email{daniele.baisero@gmail.com}
}
\keyword{internal}
