% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quota_methods.R
\name{largest_remainder_method}
\alias{largest_remainder_method}
\title{Largest remainder method}
\usage{
largest_remainder_method(votes, n_seats, quorum = 0)
}
\arguments{
\item{votes}{numeric vector with number of votes for each party}

\item{n_seats}{total number of seats}

\item{quorum}{Vote threshold a party must reach. Used as fraction of total
votes within if less than 1 otherwise as number
of votes.}
}
\value{
The number of seats per party as a vector
}
\description{
Allocate seats based on the largest fractional remainder. The largest remainder method is
also known as Hamilton, Hare-Niemeyer or Vinton method.
}
\details{
The numbers of votes for each party is divided by a quota representing the number of
votes required for a seat. Then, each party receives the rounded down quota value as
seats. The remaining seats are given to the party with the largest remainder until all
seats have been distributed.
}
\note{
Only the quota \verb{total votes / total seats} (which is used by the aforementioned
methods) is implemented.
}
\examples{
votes = c(47000, 16000, 15800, 12000, 6100, 3100)
largest_remainder_method(votes, 10)

}
\seealso{
\code{\link[=proporz]{proporz()}}
}
