% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{homologue_lg_assignment}
\alias{homologue_lg_assignment}
\title{Assign markers to linkage groups and homologues.}
\usage{
homologue_lg_assignment(
  input_type = "discrete",
  dosage_matrix,
  probgeno_df,
  chk,
  assigned_list,
  assigned_markertypes,
  SN_functions = NULL,
  LG_hom_stack,
  parent1 = "P1",
  parent2 = "P2",
  which_parent = 1,
  ploidy,
  ploidy2 = NULL,
  convert_palindrome_markers = TRUE,
  pairing = "random",
  LG_number,
  LOD_threshold = 3,
  write_intermediate_files = TRUE,
  log = NULL,
  ...
)
}
\arguments{
\item{input_type}{Can be either one of 'discrete' or 'probabilistic'. For the former (default), \code{dosage_matrix} must be supplied,
while for the latter \code{probgeno_df} and \code{chk} must be supplied.}

\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns.}

\item{probgeno_df}{A data frame as read from the scores file produced by function
\code{saveMarkerModels} of R package \code{fitPoly}, or alternatively, a data frame containing the following columns:
\describe{
\item{SampleName}{
Name of the sample (individual)
}
\item{MarkerName}{
Name of the marker
}
\item{P0}{
Probabilities of dosage score '0'
}
\item{P1...}{
Probabilities of dosage score '1' etc. (up to max dosage, e.g. P4 for tetraploid population)
}
\item{maxP}{
Maximum genotype probability identified for a particular individual and marker combination
}
\item{maxgeno}{
Most probable dosage for a particular individual and marker combination
}
\item{geno}{
Most probable dosage for a particular individual and marker combination, if \code{maxP} exceeds a user-defined threshold (e.g. 0.9), otherwise \code{NA}}
}}

\item{chk}{Output list as returned by function \code{\link{checkF1}}. This argument is only needed if probabilistic genotypes are used.}

\item{assigned_list}{List of \code{data.frames} with marker assignments for which the assignment analysis is already performed.}

\item{assigned_markertypes}{List of integer vectors of length 2. Specifying the markertypes in the same order as assigned_list.}

\item{SN_functions}{A vector of function names to be used. If NULL all remaining linkage functions with SN markers are used.}

\item{LG_hom_stack}{A \code{data.frame} with markernames (\code{"SxN_Marker"}), linkage group (\code{"LG"}) and homologue (\code{"homologue"})}

\item{parent1}{A character string specifying name of parent1.}

\item{parent2}{A character string specifying the name of parent2.}

\item{which_parent}{Integer, either 1 or 2, with default 1, where 1 or 2 refers to parent1 or parent2 respectively.}

\item{ploidy}{Ploidy level of parent 1. If parent 2 has the same ploidy level, then also the ploidy level of parent 2.}

\item{ploidy2}{Integer, by default \code{NULL}. If parental ploidies differ, use this to specify the ploidy of parent 2. Note that in cross-ploidy situations, ploidy2 must be smaller than ploidy.}

\item{convert_palindrome_markers}{Logical. Should markers that behave the same for both parents be converted to a workable format for that parent? E.g.: should 3.1 markers be converted to 1.3?}

\item{pairing}{Type of pairing. Either \code{"random"} or \code{"preferential"}. By default random pairing is assumed.}

\item{LG_number}{Expected number of chromosomes (linkage groups).}

\item{LOD_threshold}{LOD threshold at which a linkage is considered significant.}

\item{write_intermediate_files}{Logical. Write intermediate linkage files to working directory?}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}

\item{\dots}{Arguments passed to \code{\link{linkage}}}
}
\value{
A \code{data.frame} specifying marker assignments to linkage group and homologue.
}
\description{
This is a wrapper combining \code{\link{linkage}} (or \code{\link{linkage.gp}}) and \code{\link{assign_linkage_group}}. 
It is used to assign all marker types to linkage groups by using linkage information with 1.0 markers. It allows for input of marker assignments for which this analysis has already been performed.
}
\examples{
\dontrun{
data("screened_data3", "P1_SxS_Assigned", "P1_DxN_Assigned", "LGHomDf_P1_1")
Assigned_markers<-homologue_lg_assignment(dosage_matrix = screened_data3,
                                          assigned_list = list(P1_SxS_Assigned, P1_DxN_Assigned),
                                          assigned_markertypes = list(c(1,1), c(2,0)),
                                          LG_hom_stack = LGHomDf_P1_1,ploidy=4,LG_number = 5,
                                          write_intermediate_files=FALSE)
                         }
}
