% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context-selectors.R
\name{everyone}
\alias{everyone}
\alias{everyone_but}
\title{Select all authors or exclude some from a selection}
\usage{
everyone()

everyone_but(...)
}
\arguments{
\item{...}{One or more unquoted expressions separated by commas. Expressions
matching values in the column defined by the \code{by} or \code{.by} parameter
are used to set a given status to authors. Matching of values is case-
insensitive and dot-agnostic.}
}
\description{
Selection helpers to use in conjonction with status setter methods (i.e.
methods that assign a status to authors with either \code{TRUE} or \code{FALSE}):
\itemize{
\item \code{everyone()} select all authors.
\item \code{everyone_but()} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} this function was
deprecated as I believe it is not necessary since not more than a couple of
authors should normally be given a particular status.
}
}
\examples{
aut <- Plume$new(encyclopedists)

aut$set_corresponding_authors(everyone())
dplyr::select(aut$data(), 1:3, corresponding)
}
\keyword{internal}
