% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pix_fraud_stats.R
\name{get_pix_fraud_stats_multi}
\alias{get_pix_fraud_stats_multi}
\title{Get PIX Fraud Statistics for Multiple Months}
\usage{
get_pix_fraud_stats_multi(databases, ...)
}
\arguments{
\item{databases}{Character vector of year-months in "YYYYMM" format.}

\item{...}{Additional arguments passed to \code{\link[=get_pix_fraud_stats]{get_pix_fraud_stats()}}.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with combined fraud statistics.
}
\description{
Retrieves fraud statistics for multiple months and combines them
into a single tibble.
}
\examples{
\donttest{# It usually takes much longer than 5 seconds.
# Get fraud data for Q3 2025
q3_fraud <- get_pix_fraud_stats_multi(
  databases = c("202507", "202508", "202509")
)
}
}
