#' @title CIE D65 illuminant data
#'
#' @description A dataset containing wavelengths at a 5 nm interval (300 nm to
#'   830 nm) and the corresponding spectral energy irradiance normalized to 1 at
#'   560 nm. Spectrum approximates the midday solar spectrum at middle latitude
#'   as 'corresponds' to the white point of a black body a 6504 K. Original data
#'   from CIE downloaded on 2024-11-30 The variables are as follows:
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#' @format A source spectrum with 531 rows and 2 variables
#'
#' \itemize{ \item w.length (nm) \item s.e.irrad (rel. units) }
#'
#' @family Spectral data examples
#'
#' @references CIE 2022, CIE standard illuminant D65, International Commission
#' on Illumination (CIE), Vienna, Austria, \doi{10.25039/CIE.DS.hjfjmt59}.
#'
#' @note This and other CIE illuminant spectra can be downloaded from
#'   \url{https://cie.co.at/data-tables} as .CSV files.
#'
#' @examples
#' D65.illuminant.spct
#'
"D65.illuminant.spct"

#' @title CIE D50 illuminant data
#'
#' @description A dataset containing wavelengths at a 5 nm interval (300 nm to
#'   830 nm) and the corresponding spectral energy irradiance normalized to 1 at
#'   560 nm. Spectrum approximates the midday solar spectrum at middle latitude
#'   as 'corresponds' to the white point of a black body a 6504 K. Original data
#'   from CIE downloaded on 2024-11-30 The variables are as follows:
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#' @format A source spectrum with 531 rows and 2 variables
#'
#' \itemize{ \item w.length (nm) \item s.e.irrad (rel. units) }
#'
#' @family Spectral data examples
#'
#' @references CIE 2022, Relative spectral power distributions of CIE standard
#' illuminants A, D65 and D50 (wavelengths in standard air) (data table),
#' International Commission on Illumination (CIE), Vienna, Austria,
#' \doi{10.25039/CIE.DS.etgmuqt5}.
#'
#' @note This and other CIE illuminant spectra can be downloaded from
#'   \url{https://cie.co.at/data-tables} as .CSV files.
#'
#' @examples
#' D50.illuminant.spct
#'
"D50.illuminant.spct"

#' @title CIE A illuminant data
#'
#' @description A dataset containing wavelengths at a 5 nm interval (300 nm to
#'   830 nm) and the corresponding spectral energy irradiance normalized to 1 at
#'   560 nm. Spectrum approximates typical, domestic, tungsten-filament lighting
#'   and 'corresponds' to a black body a 2856 K. CIE standard illuminant A is
#'   intended to represent typical, domestic, tungsten-filament lighting.
#'   Original data from CIE downloaded on 2024-11-30.
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#'
#' @format A source spectrum with 531 rows and 2 variables.
#'
#' \itemize{ \item w.length (nm) \item s.e.irrad (rel. units) }
#'
#' @family Spectral data examples
#'
#' @references
#' CIE 2018, CIE standard illuminant A - 1 nm, International
#' Commission on Illumination (CIE), Vienna, Austria,
#' \doi{10.25039/CIE.DS.8jsxjrsn}.
#'
#' @note This and other CIE illuminant spectra can be downloaded from
#'   \url{https://cie.co.at/data-tables} as .CSV files.
#'
#' @examples
#' A.illuminant.spct
#'
"A.illuminant.spct"
