% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{textDist_sparse}
\alias{textDist_sparse}
\title{Calculate Text Distance (sparse version)}
\usage{
textDist_sparse(xi, xx, yi, yx, zeroes = 0.5)
}
\arguments{
\item{xi}{An integer vector with the row ids of the vector x}

\item{xx}{A numeric vector with the values of the nonzero elements of x}

\item{yi}{An integer vector with the row ids of the vector y}

\item{yx}{A numeric vector with the values of the nonzero elements of y}

\item{zeroes}{Text distance when both vectors are zero vectors; default is .5}
}
\value{
the text distance between the vectors x and y.
}
\description{
When two vectors are given, this calculates the text distance between them;
text distance is calculated as the proportion of unmatched frequencies, i.e.,
the number of unmatched frequencies divided by the total frequencies among
the two vectors. However, if neither vector has any values
at all, their distance equals the number provided in the zeroes argument,
which is .5 by default. When two matrices are given, the text distance
between corresponding columns is calculated.
}
\examples{
x=c(1,0,0,2,4,0,0,0,2,1,0,0)
y=c(2,0,0,0,2,0,0,1,0,3,1,0)
textDist_sparse(which(x!=0),x[x!=0],which(y!=0),y[y!=0])
}
