% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{textCluster}
\alias{textCluster}
\title{Cluster a Term-Document Matrix}
\usage{
textCluster(M, k, mx = 100, md = 10 * k, silent = TRUE)
}
\arguments{
\item{M}{A term document matrix with terms on the rows and documents on 
the columns.}

\item{k}{A positive integer with the number of clusters needed}

\item{mx}{Maximum number of times to iterate (default 100)}

\item{md}{Maximum number of documents to use for the initial setup (default 
10*\code{k}).}

\item{silent}{TRUE if you do not want progress messages.}
}
\value{
A textcluster object with three items; cluster, centroids, and size,
where cluster contains a vector indicating for each column in \code{M} what
cluster they have been assigned to, centroids contains a matrix with each
column the centroid of a cluster, and size a named vector with the size of
each cluster.
}
\description{
Combine documents (columns) into k clusters that have texts that are most
similar based on their text distance. Documents with no terms are assigned
to the last cluster.
}
\examples{
M=matrix(c(0,1,0,2,0,10,0,14,12,0,8,0,1,0,1,0),4)
colnames(M)=1:4;rownames(M)=c("A","B","C","D")
textCluster(M,2)
}
