% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_boin12.R
\name{simulate_boin12}
\alias{simulate_boin12}
\title{Simulate operating characteristics using BOIN12.}
\usage{
simulate_boin12(
  ndose,
  ssizerange,
  target_t,
  lower_e,
  cohortsize = 3,
  startdose = 1,
  psafe = 0.95,
  pfutility = 0.9,
  ntrial = 10000,
  utilitytype = 1,
  u1,
  u2,
  prob = NULL,
  save_dir = tempdir(),
  save_folder = "boin12_simulations",
  save_file = "boin12_simulation.csv"
)
}
\arguments{
\item{ndose}{Integer. Number of dose levels. (\strong{Required})}

\item{ssizerange}{Integer vector. Range of number of cohorts to simulate. (\strong{Required})}

\item{target_t}{Numeric. Target toxicity probability. (\strong{Required})}

\item{lower_e}{Numeric. Minimum acceptable efficacy probability. (\strong{Required})}

\item{cohortsize}{Integer. Size of a cohort. (Default is \code{3})}

\item{startdose}{Integer. Starting dose level. (Default is \code{1})}

\item{psafe}{Numeric. Early stopping cutoff for toxicity. (Default is \code{0.95})}

\item{pfutility}{Numeric. Early stopping cutoff for efficacy. (Default is \code{0.90})}

\item{ntrial}{Integer. Number of random trial replications. (Default is \code{10000})}

\item{utilitytype}{Integer. Type of utility structure. (Default is \code{1})
\itemize{
\item If set to \code{1}: Use preset weights (w11 = 0.6, w00 = 0.4)
\item If set to \code{2}: Use (w11 = 1, w00 = 0)
\item Other: Use user-specified values from \code{u1} and \code{u2}.
}}

\item{u1}{Numeric. Utility parameter w_11. (0-100)}

\item{u2}{Numeric. Utility parameter w_00. (0-100)}

\item{prob}{Fixed probability vectors. If not specified, a random scenario is used by default.
Use this parameter to provide fixed probability vectors as a list with the following named elements:
\itemize{
\item \code{pE}: Numeric vector of efficacy probabilities for each dose level.
\item \code{pT}: Numeric vector of toxicity probabilities for each dose level.
\item \code{obd}: Integer indicating the index of the true Optimal Biological Dose (OBD).
\item \code{mtd}: Integer indicating the index of the true Maximum Tolerated Dose (MTD).
}

For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{prob <- list(
  pE = c(0.4, 0.5, 0.6, 0.6, 0.6),
  pT = c(0.1, 0.2, 0.3, 0.4, 0.4),
  obd = 3,
  mtd = 2
)
}\if{html}{\out{</div>}}}

\item{save_dir}{Directory to save output folders. Default is \code{tempdir()}.}

\item{save_folder}{Folder name. (Default is "boin12_simulations")}

\item{save_file}{File name. (Default is "boin12_simulation.csv")}
}
\value{
No return value, called for side effects
}
\description{
This function runs simulations of the BOIN12 design by
evaluating operating characteristics over a range of cohort sizes. For each
dose level within the user-specified range, it performs multiple trials and saves the results to a corresponding file.
}
\examples{
prob <- list(
  pE = c(0.4, 0.5, 0.6),
  pT = c(0.1, 0.2, 0.3),
  obd = 2,
  mtd = 2
)
simulate_boin12(
  ndose = 3,
  ssizerange = c(3, 5),
  target_t = 0.3,
  lower_e = 0.2,
  ntrial = 10,
  prob = prob,
)
}
