% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binding.r
\name{binding1to1}
\alias{binding1to1}
\title{Generate a 1:1 Binding Curve}
\usage{
binding1to1(t, t0, conc, kon, koff, rmax, drift = 0, offset = 0, doffset = 0)
}
\arguments{
\item{t}{Time.}

\item{t0}{Time of dissociation.}

\item{conc}{Analyte concentration.}

\item{kon}{Kon binding constant.}

\item{koff}{Koff binding constant.}

\item{rmax}{Maximum response, Rmax.}

\item{drift}{Optional. Parameter to add a linear baseline drift.}

\item{offset}{Optional. Applies a global offset to the response value.}

\item{doffset}{Optional. Applies an offset at the start of dissociation.}
}
\description{
Returns a response value for given parameters at time, t.
}
\examples{
time <- seq(1,2000)
curve <- binding1to1(time,1000,6e-9,1000,0.01,0.6)
plot(curve)
}
\keyword{binding1to1}
