% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_chunk_options.R
\name{chunk_options}
\alias{chunk_options}
\alias{rmd_set_options}
\alias{rmd_get_options}
\title{Get and set code chunk options}
\usage{
rmd_set_options(x, ...)

rmd_get_options(x, ..., defaults = list(), yaml_style = TRUE)
}
\arguments{
\item{x}{An \code{rmd_ast}, \code{rmd_tibble}, or any rmd ast node object.}

\item{...}{Either a collection of named values for the setter or a character values
of the option names for the getter.}

\item{defaults}{A named list of default values for the options.}

\item{yaml_style}{logical, if \code{TRUE} (default) return option names in YAML style (with hyphens), if \code{FALSE} return normalized style (with dots)}
}
\value{
\code{rmd_set_options} returns the modified version of the original object.

\code{rmd_get_options} returns a list of the requested options (or all options if none
are specified). Non-chunk nodes return \code{NULL}.
}
\description{
Helper functions for obtaining or changing chunk options
within an rmd object.
}
\examples{
rmd = parse_rmd(system.file("examples/minimal.Rmd", package = "parsermd"))

str(rmd_get_options(rmd))
str(rmd_get_options(rmd, "include"))

# Get options in YAML style (default) vs normalized style
chunk = rmd_chunk("r", "test", options = list(`fig-width` = 8, eval = TRUE))
rmd_get_options(chunk, yaml_style = TRUE)   # fig-width
rmd_get_options(chunk, yaml_style = FALSE)  # fig.width

rmd_set_options(rmd, include = TRUE)

}
