% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_ordregr_print.R
\name{print.ordregr}
\alias{print.ordregr}
\title{Print an 'ordregr' or an 'ordgam' object.}
\usage{
\method{print}{ordregr}(x, expEst, ...)
}
\arguments{
\item{x}{An \link{ordregr.object} generated by \link{ordregr} or \link{ordgam}.}

\item{expEst}{Logical indicating if the exponential of the regression coefficients should be printed (Default: TRUE)}

\item{...}{Possible additional printing options.}
}
\value{
Print summary statistics.
}
\description{
Print a summary of the information contained in an \code{\link{ordregr.object}} or \code{\link{ordgam.object}} generated by \code{\link{ordregr}} or \code{\link{ordgam}}.
}
\examples{
library(ordgam)
data(freehmsData)
mod = ordgam(freehms ~ gndr + s(eduyrs) + s(age),
             data=freehmsData, descending=TRUE)
print(mod)
plot(mod)

}
\references{
Lambert, P. and Gressani, 0. (2023) Penalty parameter selection and asymmetry corrections
to Laplace approximations in Bayesian P-splines models. Statistical Modelling. <doi:10.1177/1471082X231181173>. Preprint: <arXiv:2210.01668>.
}
\seealso{
\code{\link{ordregr}}, \code{\link{ordgam}}
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
