% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMonotoneFunction.R
\name{getMonotoneFunction}
\alias{getMonotoneFunction}
\title{Return Monotone Function Values}
\usage{
getMonotoneFunction(
  x,
  fun,
  lower = NULL,
  upper = NULL,
  argument = NULL,
  nSteps = 10^4,
  epsilon = 10^(-5),
  numberOfIterationsQ = 10^4,
  design
)
}
\arguments{
\item{x}{Argument values.}

\item{fun}{The function to be made monotone.}

\item{lower}{The lower limit of the interval on which the function should be monotonised. Must be a numeric value.}

\item{upper}{The upper limit of the interval on which the function should be monotonised.}

\item{argument}{The argument in which the function should be monotonised, given as a character.}

\item{nSteps}{The number of steps to be taken when checking the function for monotonicity. Must be a numeric value. Default 10^4.}

\item{epsilon}{Maximum allowed difference between the initial and monotone integral. Must be a numeric value. Default 10^-5.}

\item{numberOfIterationsQ}{Maximum number of iterations allowed to determine each value of q. Must be a numeric value. Default 10^4.}

\item{design}{An object of class \code{TrialDesignOptimalConditionalError} created by \code{getDesignOptimalConditionalErrorFunction()}. Contains all necessary arguments to calculate the optimal conditional error function for the specified case.}
}
\value{
Monotone function values.
}
\description{
Applies the provided monotonisation constants to a specified, possibly non-monotone function. The returned function values are non-increasing.
}
\details{
The exact monotonisation process is outlined in Brannath et al. (2024), but specified in terms of the first-stage test statistic \eqn{z_1} rather than the first-stage p-value \eqn{p_1}. \cr
The algorithm can easily be translated to the use of p-values by switching the maximum and minimum functions, i.e., replacing \eqn{\min\{q, Q(z_1)\}} by \eqn{\max\{q, Q(p_1)\}} and \eqn{\min\{q, Q(z_1)\}} by \eqn{\max\{q, Q(p_1\}}.
}
\references{
Brannath, W., Dreher, M., zur Verth, J., Scharpenberg, M. (2024). Optimal monotone conditional error functions. https://arxiv.org/abs/2402.00814
}
