% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_sparklines}
\alias{wb_add_sparklines}
\title{Add sparklines to a worksheet}
\usage{
wb_add_sparklines(wb, sheet = current_sheet(), sparklines)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object.}

\item{sheet}{The name or index of the worksheet where the sparklines will
be rendered. Defaults to the current sheet.}

\item{sparklines}{A character vector of sparkline XML strings generated
by \code{\link[=create_sparklines]{create_sparklines()}}.}
}
\description{
\code{wb_add_sparklines()} takes the XML definitions created by \code{\link[=create_sparklines]{create_sparklines()}}
and embeds them into the specified worksheet of a \code{wbWorkbook}.
}
\examples{
 sl <- create_sparklines("Sheet 1", dims = "A3:K3", sqref = "L3")
 wb <- wb_workbook()
 wb <- wb_add_worksheet(wb)
 wb <- wb_add_data(wb, x = mtcars)
 wb <- wb_add_sparklines(wb, sparklines = sl)
}
\seealso{
\code{\link[=create_sparklines]{create_sparklines()}}
}
