% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_vd.R
\name{search_vd}
\alias{search_vd}
\title{Search VecDyn by keyword}
\usage{
search_vd(keywords, basereq = vb_basereq())
}
\arguments{
\item{keywords}{either a string of search terms separated by spaces, or a vector of keywords.}

\item{basereq}{an \link[httr2:request]{httr2 request} object, as generated by \code{\link[=vb_basereq]{vb_basereq()}}. If \code{NA}, uses the default request.}
}
\value{
An \code{ohvbd.ids} vector of VecDyn dataset IDs.
}
\description{
Retrieve the IDs for any VecDyn datasets matching the given keywords
}
\note{
\code{\link[=search_hub]{search_hub()}} is now preferred for keyword searches:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# old style
search_vd(c("Ixodes", "ricinus")

# new style
search_hub("Ixodes ricinus", db = "vd")
}\if{html}{\out{</div>}}

\code{search_vd()} may be deprecated in the future.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
search_vd("Aedes aegypti")

search_vd(c("Aedes", "aegypti"))
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{vecdyn}
