% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_hub.R
\name{filter_db}
\alias{filter_db}
\title{Filter hub search results by database}
\usage{
filter_db(ids, db)
}
\arguments{
\item{ids}{an \code{ohvbd.hub.search} search result from \code{\link[=search_hub]{search_hub()}}.}

\item{db}{a database name as a string. One of \code{"vt"}, \code{"vd"}, \code{"gbif"}, \code{"px"}.}
}
\value{
An \code{ohvbd.ids} vector of dataset IDs.
}
\description{
Retrieve the IDs for any datasets matching the given database.
}
\note{
If \code{\link[=filter_db]{filter_db()}} recieves an \code{ohvbd.ids} object by mistake, it will transparently return it if the source database matches \code{db}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
search_hub("Ixodes ricinus")

search_hub("Ixodes ricinus") |>
  filter_db("vt") |>
  fetch() |>
  glean()
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{hub}
