% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_gadm_sfs.R
\name{fetch_gadm_sfs}
\alias{fetch_gadm_sfs}
\title{Fetch gadm mapping shapefiles}
\usage{
fetch_gadm_sfs(
  gid = 0,
  cache_location = NULL,
  refresh_cache = FALSE,
  basereq = ad_basereq(),
  call = rlang::caller_env()
)
}
\arguments{
\item{gid}{the spatial scale to retrieve (0 = country-level, 1=province-level...).}

\item{cache_location}{path to cache location (defaults to a temporary user directory, or one set by \code{\link[=set_default_ohvbd_cache]{set_default_ohvbd_cache()}}).}

\item{refresh_cache}{force a refresh of the relevant cached data.}

\item{basereq}{the url of the AREAdata database (usually generated by \code{\link[=ad_basereq]{ad_basereq()}}). If \code{NA}, uses the default.}

\item{call}{The env from which this was called (defaults to the direct calling environment).}
}
\value{
A SpatVector (from \code{\link[terra:vect]{terra::vect()}}) of the requested shapefile.
}
\description{
Retrieve AREAdata gadm mapping shapefiles specified by spatial scale (GID). These vectors are cached as GeoPackage files.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_gadm_sfs(gid=0)
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{areadata}
