% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_location.R
\name{ph_location_id}
\alias{ph_location_id}
\title{Location of a placeholder based on its id}
\usage{
ph_location_id(id, newlabel = NULL, ...)
}
\arguments{
\item{id}{placeholder id.}

\item{newlabel}{a new label to associate with the placeholder.}

\item{...}{not used.}
}
\description{
Each placeholder has an id (a low integer value). The ids are unique across a single
layout. The function uses the placeholder's id to reference it. Different from a ph label,
the id is auto-assigned by PowerPoint and cannot be modified by the user.
Use \code{\link[=layout_properties]{layout_properties()}} (column \code{id}) and \code{\link[=plot_layout_properties]{plot_layout_properties()}} (upper right
corner, in green) to find a placeholder's id.
}
\details{
The location of the bounding box associated to a placeholder
within a slide is specified with the left top coordinate,
the width and the height. These are defined in inches:

\describe{
\item{left}{left coordinate of the bounding box}
\item{top}{top coordinate of the bounding box}
\item{width}{width of the bounding box}
\item{height}{height of the bounding box}
}

In addition to these attributes, a label can be
associated with the shape. Shapes, text boxes, images and other objects
will be identified with that label in the \emph{Selection Pane} of PowerPoint.
This label can then be reused by other functions such as \code{ph_location_label()}.
It can be set with argument \code{newlabel}.
}
\examples{
library(officer)

doc <- read_pptx()
doc <- add_slide(doc, "Comparison")
plot_layout_properties(doc, "Comparison")

doc <- ph_with(doc, "The Title", location = ph_location_id(id = 2)) # title
doc <- ph_with(doc, "Left Header", location = ph_location_id(id = 3)) # left header
doc <- ph_with(doc, "Left Content", location = ph_location_id(id = 4)) # left content
doc <- ph_with(doc, "The Footer", location = ph_location_id(id = 8)) # footer

file <- tempfile(fileext = ".pptx")
print(doc, file)

## file.show(file) # may not work on your system
}
\seealso{
Other functions for placeholder location: 
\code{\link{ph_location}()},
\code{\link{ph_location_fullsize}()},
\code{\link{ph_location_label}()},
\code{\link{ph_location_left}()},
\code{\link{ph_location_right}()},
\code{\link{ph_location_template}()},
\code{\link{ph_location_type}()}
}
\concept{functions for placeholder location}
