% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiet.R
\name{quiet}
\alias{quiet}
\title{Silence R code}
\usage{
quiet(x, print_cat = TRUE, message = TRUE, warning = TRUE)
}
\arguments{
\item{x}{[\code{expression}]\cr
Any function or expression or value assignment expression.}

\item{print_cat}{[\code{logical(1)}]\cr
Silence \code{print()} and \code{cat()} outputs?}

\item{message}{[\code{logical(1)}]\cr
Silence messages?}

\item{warning}{[\code{logical(1)}]\cr
Silence warnings?}
}
\value{
Invisibly the expression \code{x}.
}
\description{
This function silences warnings, messages and any \code{cat()} or \code{print()}
output from R expressions or functions.
}
\examples{
f <- function() {
  warning("warning")
  message("message")
  cat("cat")
  print("print")
}
quiet(f())
}
\references{
This function is a modified version of \code{\link[spsUtil]{quiet}}.
}
\seealso{
Other function helpers: 
\code{\link{do.call_timed}()},
\code{\link{function_arguments}()},
\code{\link{function_body}()},
\code{\link{function_defaults}()},
\code{\link{timed}()},
\code{\link{try_silent}()},
\code{\link{variable_name}()}
}
\concept{function helpers}
\keyword{functional}
