% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_tv.R
\name{gaussian_tv}
\alias{gaussian_tv}
\title{Gaussian total variation}
\usage{
gaussian_tv(
  mean1,
  mean2,
  Sigma1,
  Sigma2,
  method = c("auto", "mc", "cubature"),
  n = 10000,
  tol_equal = 1e-06,
  eps = 1e-06
)
}
\arguments{
\item{mean1, mean2}{[\code{numeric(p)}]\cr
The mean vectors.}

\item{Sigma1, Sigma2}{[\code{matrix(nrow = p, ncol = p)}]\cr
The covariance matrices.}

\item{method}{[\code{character(1)}]\cr
Computation method. One of:
\itemize{
\item \code{"auto"}: use closed-form formula when covariances are equal, otherwise
use \code{"cubature"} for \eqn{p \le 2} and \code{"mc"} for higher dimensions.
\item \code{"mc"}: estimate via Monte Carlo importance sampling from the mixture
\eqn{0.5 (f_1 + f_2)}.
\item \code{"cubature"}: compute overlap via adaptive cubature integration over a
bounding box, then convert to TV. Exact but slow for \eqn{p \ge 2}.
}}

\item{n}{[\code{integer(1)}]\cr
Number of Monte Carlo samples to draw.}

\item{tol_equal}{[\code{numeric(1)}]\cr
Numerical tolerance used to decide whether \code{Sigma1} and \code{Sigma2} are
considered equal (enabling the closed-form formula in \code{"auto"} mode).}

\item{eps}{[\code{numeric(1)}]\cr
Only used when \code{method = "cubature"}. Specifies the total probability mass
allowed to lie outside the integration hyper-rectangle across all dimensions.
This determines the numerical integration bounds: the function chooses limits
so that the probability of a point from either Gaussian falling outside the
box is at most \code{eps}. The bound is split evenly across dimensions via a union
bound, so the per-dimension tail probability is approximately \code{eps / p}.
Smaller values produce wider bounds (slower but more accurate integration),
while larger values yield narrower bounds (faster but potentially less
accurate).}
}
\value{
The total variation in [0, 1].
}
\description{
Computes the total variation (TV) between two multivariate Gaussian
distributions \eqn{f_1,f_2}: \deqn{\mathrm{TV}(f_1, f_2) = \tfrac{1}{2}
\int_{\mathbb{R}^p} \lvert f_1(x) - f_2(x) \rvert \, dx.}
The value ranges from 0 (identical distributions) to 1 (no overlap).
}
\examples{
### univariate case
mean1 <- 0
mean2 <- 1
Sigma1 <- Sigma2 <- matrix(1)
gaussian_tv(mean1, mean2, Sigma1, Sigma2)

### bivariate case
mean1 <- c(0, 0)
mean2 <- c(1, 1)
Sigma1 <- matrix(c(1, 0.2, 0.2, 1), ncol = 2)
Sigma2 <- matrix(c(1.5, -0.3, -0.3, 1), ncol = 2)
gaussian_tv(mean1, mean2, Sigma1, Sigma2, method = "mc", n = 1e3)
}
\seealso{
Other simulation helpers: 
\code{\link{Simulator}},
\code{\link{correlated_regressors}()},
\code{\link{ddirichlet_cpp}()},
\code{\link{dmixnorm_cpp}()},
\code{\link{dmvnorm_cpp}()},
\code{\link{dtnorm_cpp}()},
\code{\link{dwishart_cpp}()},
\code{\link{simulate_markov_chain}()}
}
\concept{simulation helpers}
\keyword{distribution}
