% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_defaults.R
\name{function_defaults}
\alias{function_defaults}
\title{Get default function arguments}
\usage{
function_defaults(f, exclude = NULL)
}
\arguments{
\item{f}{[\code{function}]\cr
A \code{function}.}

\item{exclude}{[\code{NULL} | \code{character()}]\cr
Argument names to exclude.

Can be \code{NULL} (default) to not exclude any argument names.}
}
\value{
A named \code{list}.
}
\description{
This function returns the default function arguments (if any).
}
\examples{
f <- function(a, b = 1, c = "", ...) { }
function_defaults(f)
function_defaults(f, exclude = "b")
}
\seealso{
Other function helpers: 
\code{\link{do.call_timed}()},
\code{\link{function_arguments}()},
\code{\link{function_body}()},
\code{\link{quiet}()},
\code{\link{timed}()},
\code{\link{try_silent}()},
\code{\link{variable_name}()}
}
\concept{function helpers}
\keyword{functional}
