% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_transition_probability_matrix.R
\name{check_transition_probability_matrix}
\alias{check_transition_probability_matrix}
\alias{assert_transition_probability_matrix}
\alias{test_transition_probability_matrix}
\title{Check transition probability matrix}
\usage{
check_transition_probability_matrix(
  x,
  dim = NULL,
  tolerance = sqrt(.Machine$double.eps)
)

assert_transition_probability_matrix(
  x,
  dim = NULL,
  tolerance = sqrt(.Machine$double.eps),
  .var.name = checkmate::vname(x),
  add = NULL
)

test_transition_probability_matrix(
  x,
  dim = NULL,
  tolerance = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{dim}{[\code{integer(1)}]\cr
The matrix dimension.}

\item{tolerance}{[\code{numeric(1)}]\cr
A non-negative tolerance value.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}
}
\value{
Same as documented in \code{\link[checkmate]{check_matrix}}.
}
\description{
These functions check whether the input is a transition probability matrix.
}
\examples{
T <- matrix(c(0.8,  0.2,  0.1, 0.1,  0.7,  0.4, 0.1,  0.1,  0.6), nrow = 3)
check_transition_probability_matrix(T)
test_transition_probability_matrix(T)
\dontrun{
assert_transition_probability_matrix(T)
}
}
\seealso{
Other matrix helpers: 
\code{\link{check_correlation_matrix}()},
\code{\link{check_covariance_matrix}()},
\code{\link{cov_to_chol}()},
\code{\link{diff_cov}()},
\code{\link{insert_matrix_column}()},
\code{\link{matrix_diagonal_indices}()},
\code{\link{matrix_indices}()},
\code{\link{sample_correlation_matrix}()},
\code{\link{sample_covariance_matrix}()},
\code{\link{sample_transition_probability_matrix}()},
\code{\link{stationary_distribution}()}
}
\concept{matrix helpers}
\keyword{validation}
