% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hal_search.R
\name{hal_search}
\alias{hal_search}
\alias{hal_search.HALQuery}
\title{Search}
\usage{
hal_search(query, ...)

\method{hal_search}{HALQuery}(
  query,
  path = "search",
  instance = NULL,
  limit = 30,
  start = 0,
  cursor = FALSE,
  max_requests = Inf,
  on_error = "stop",
  progress = getOption("odyssey.progress"),
  verbose = getOption("odyssey.verbose"),
  ...
)
}
\arguments{
\item{query}{An object of class \code{HALQuery} (typically returned by \code{\link[=hal_query]{hal_query()}}).}

\item{...}{Currently not used.}

\item{path}{A \code{\link{character}} string giving the API name
(defaults to "\code{search}").}

\item{instance}{A \code{\link{character}} string giving the HAL portal name.}

\item{limit}{An \code{\link{integer}} giving the maximum number of results.
According to HAL policy, it cannot exceed 10000.}

\item{start}{An \code{\link{integer}} specifying an absolute offset in the complete
sorted list of matches to be used as the beginning of the current page.
Only used if \code{cursor} is \code{FALSE}.}

\item{cursor}{A \code{\link{logical}} scalar: should a cursor be used for
the pagination of results? If \code{TRUE}, the \code{sort} parameter of the
query will set to "\code{docid asc}".}

\item{max_requests}{An \code{\link{integer}} specifying the maximum number of requests
to perform. Use \code{Inf} to perform all requests. Only used if \code{cursor} is
\code{TRUE}.}

\item{on_error}{A \code{\link{character}} string specifying what should happen if a
request fails (see \code{\link[httr2:req_perform_iterative]{httr2::req_perform_iterative()}}). Only used if \code{cursor}
is \code{TRUE}.}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar for
for the request be printed?}

\item{verbose}{A \code{\link{logical}} scalar: should extra information be reported?}
}
\value{
A \code{\link{list}} of class \code{HALSearch}.
}
\description{
Search
}
\examples{
\dontrun{
## Simple search
topic <- list("archéologie", "Celtes", "France") # Combined with AND
## Get the first ten results
hal_query(topic) |>
  hal_search(limit = 10) |>
  as.data.frame()
## Get all results
hal_query(topic) |>
  hal_search(limit = 30, cursor = TRUE) |>
  as.data.frame()

## Get a list of archaeological journals
topic <- c("archéologie", "archaeology", "archäologie") # Combined with OR
hal_query(topic) |>
  hal_select("title_s", "issn_s") |>
  hal_filter("" \%TO\% "*" \%IN\% "issn_s") |>
  hal_sort("title_s") |>
  hal_search(path = "ref", instance = "journal") |>
  as.data.frame()

## Get a list of archaeological laboratories
## (only joint laboratories of the CNRS and a French university)
topic <- list("archéologie" \%IN\% "text", "UMR" \%IN\% "code_t")
hal_query(topic) |>
  hal_select("name_s", "acronym_s", "code_s") |>
  hal_filter("VALID" \%IN\% "valid_s") |>
  hal_sort("acronym_s", decreasing = TRUE) |>
  hal_search(path = "ref", instance = "structure", limit = 15) |>
  as.data.frame()
}
}
\references{
\href{https://solr.apache.org/}{Apache Solr documentation}.

\href{https://api.archives-ouvertes.fr/docs/search}{HAL search documentation}.

\href{https://api.archives-ouvertes.fr/docs/ref}{HAL reference frame documentation}.
}
\seealso{
Other search tools: 
\code{\link{hal_count}()},
\code{\link{hal_download}()}
}
\author{
N. Frerebeau
}
\concept{search tools}
