% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hal_filter.R
\docType{methods}
\name{hal_filter}
\alias{hal_filter}
\alias{hal_filter.HALQuery}
\title{Filter Results}
\usage{
hal_filter(query, ...)

\method{hal_filter}{HALQuery}(query, value, field = NULL, ...)
}
\arguments{
\item{query}{An object of class \code{HALQuery} (typically returned by \code{\link[=hal_query]{hal_query()}}).}

\item{...}{Currently not used.}

\item{value}{A \code{\link{character}} string specifying the value to be used to filter
the results.}

\item{field}{A \code{\link{character}} string specifying the field to filter along.}
}
\value{
An object of class \code{\link[=hal_query]{HALQuery}}.
}
\description{
Filter Results
}
\examples{
## Simple filer
hal_query() |> hal_filter("file", "submitType_s")

## Advanced filter
hal_query() |> hal_filter("THESE" \%OR\% "HDR", "docType_s")

## Multiple filters
hal_query() |>
  hal_filter("NOW-1MONTHS/DAY" \%TO\% "NOW/HOUR", "submittedDate_tdate") |>
  hal_filter("-notice", "submitType_s")

## Range filters
hal_query() |> hal_filter(2000 \%TO\% 2013, "submittedDateY_i")

hal_query() |> hal_filter("Aa" \%TO\% "Ab", "city_s")
}
\seealso{
Other query tools: 
\code{\link{hal_facet}()},
\code{\link{hal_group}()},
\code{\link{hal_query}()},
\code{\link{hal_select}()},
\code{\link{hal_sort}()},
\code{\link{operators}}
}
\author{
N. Frerebeau
}
\concept{query tools}
