% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{notion_client}
\alias{notion_client}
\alias{async_notion_client}
\alias{NotionClient}
\alias{AsyncNotionClient}
\title{Notion API client}
\usage{
notion_client(
  auth = NULL,
  base_url = getOption("notionapi.base_url"),
  version = getOption("notionapi.version"),
  timeout = 60000
)

async_notion_client(
  auth = NULL,
  base_url = getOption("notionapi.base_url"),
  version = getOption("notionapi.version"),
  timeout = 60000
)
}
\value{
A Notion API client instance
}
\description{
Main client for interacting with Notion API. This R6 class provides
access to all Notion API endpoints through organised sub-objects.
\subsection{Client Types}{
\itemize{
\item \code{notion_client()}: Create a synchronous client (blocks until requests complete)
\item \code{async_notion_client()}: Create an asynchronous client (non-blocking)
}

Both clients provide identical interfaces, with the async client inheriting all methods from synchronous client.
The only difference is that async methods return \href{https://rstudio.github.io/promises/}{\code{promises}} instead of results directly.
}
}
\section{Configuration fields}{
\itemize{
\item \code{auth}: Authentication token. Defaults to NOTION_TOKEN environment variable
\item \code{base_url}: Base URL for Notion API (defaults to \code{getOption("notionapi.base_url")})
\item \code{version}: Notion API version (defaults to \code{getOption("notionapi.version")})
\item \code{timeout}: Timeout for requests in milliseconds (defaults to 60000, or 60 seconds)
}
}

\section{Endpoints}{
\itemize{
\item \code{blocks}: Blocks endpoint object (\link{BlocksEndpoint})
\itemize{
\item \code{blocks$children}: Blocks children endpoint object (\link{BlocksChildrenEndpoint})
}
\item \code{pages}: Pages endpoint object (\link{PagesEndpoint})
\itemize{
\item \code{pages$properties}: Pages properties endpoint object (\link{PagesPropertiesEndpoint})
}
\item \code{databases}: Databases endpoint object (\link{DatabasesEndpoint})
\item \code{comments}: Comments endpoint object (\link{CommentsEndpoint})
\item \code{search}: Search endpoint (see \code{NotionClient$search()} method below)
\item \code{users}: Users endpoint object (\link{UsersEndpoint})
}
}

\examples{
\dontshow{if (notion_token_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# ----- Create a Notion client with default configuration
notion <- notion_client()

# search for pages and databases
\dontshow{notionapi::vcr_example_start("notion-search")}
notion$search(
  "Test Page 2025-07-15",
  page_size = 1,
  filter = list(
    value = "page",
    property = "object"
  ),
  sort = list(
    direction = "descending",
    timestamp = "last_edited_time"
  )
)
\dontshow{notionapi::vcr_example_end()}

# ----- Async client
\dontrun{
library(promises)
async_notion <- async_notion_client()

# Start multiple requests simultaneously (non-blocking)
p1 <- async_notion$search(
  query = "Testing",
  page_size = 1
)

p2 <- async_notion$users$me()

# Returns a promise object, not particularly useful on its own
p1
p2

# Use promise chaining functions to process results as they complete
p1 \%...>\%
  print()

p2 \%...>\%
  print()

# See the [promises package documentation](https://rstudio.github.io/promises/)
# for more information on working with promises
}
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://developers.notion.com/reference}{Notion API documentation}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{base_url}}{Base URL for Notion API}

\item{\code{version}}{Notion API version}

\item{\code{blocks}}{Blocks endpoint object}

\item{\code{pages}}{Pages endpoint object}

\item{\code{databases}}{Databases endpoint object}

\item{\code{comments}}{Comments endpoint object}

\item{\code{users}}{Users endpoint object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NotionClient-new}{\code{NotionClient$new()}}
\item \href{#method-NotionClient-request}{\code{NotionClient$request()}}
\item \href{#method-NotionClient-print}{\code{NotionClient$print()}}
\item \href{#method-NotionClient-search}{\code{NotionClient$search()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NotionClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-NotionClient-new}{}}}
\subsection{Method \code{new()}}{
Initialise Notion Client
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NotionClient$new(
  auth = NULL,
  base_url = "https://api.notion.com/v1/",
  version = getOption("notionapi.version"),
  timeout = 60000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{auth}}{Authentication token. Uses NOTION_TOKEN environment variable by default.}

\item{\code{base_url}}{Character. Base URL for Notion API.}

\item{\code{version}}{Character. Notion API version.}

\item{\code{timeout}}{Numeric. Number of milliseconds to wait before timing out a request.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NotionClient-request"></a>}}
\if{latex}{\out{\hypertarget{method-NotionClient-request}{}}}
\subsection{Method \code{request()}}{
Create a base \code{httr2} request object for the Notion API.

This method is primarily for advanced users who want to make custom API calls
or for debugging purposes. Most users should use the endpoint methods instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NotionClient$request()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
httr2 request object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NotionClient-print"></a>}}
\if{latex}{\out{\hypertarget{method-NotionClient-print}{}}}
\subsection{Method \code{print()}}{
Print basic details of Notion Client
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NotionClient$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NotionClient-search"></a>}}
\if{latex}{\out{\hypertarget{method-NotionClient-search}{}}}
\subsection{Method \code{search()}}{
Search all parent or child pages and databases shared with an integration
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NotionClient$search(
  query = NULL,
  sort = NULL,
  filter = NULL,
  start_cursor = NULL,
  page_size = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Character. The search query string.}

\item{\code{sort}}{Named list (JSON object). Sort condition to apply to the search results.}

\item{\code{filter}}{List (JSON object). Filter condition to apply to the search results.}

\item{\code{start_cursor}}{Character. For pagination. If provided, returns results starting from this cursor.
If NULL, returns the first page of results.}

\item{\code{page_size}}{Integer. Number of items to return per page (1-100). Defaults to 100.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/post-search}{Endpoint documentation}
}

}
}
\section{Super class}{
\code{\link[notionapi:NotionClient]{notionapi::NotionClient}} -> \code{AsyncNotionClient}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AsyncNotionClient-new}{\code{AsyncNotionClient$new()}}
\item \href{#method-AsyncNotionClient-request}{\code{AsyncNotionClient$request()}}
\item \href{#method-AsyncNotionClient-print}{\code{AsyncNotionClient$print()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="notionapi" data-topic="NotionClient" data-id="search"><a href='../../notionapi/html/NotionClient.html#method-NotionClient-search'><code>notionapi::NotionClient$search()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncNotionClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncNotionClient-new}{}}}
\subsection{Method \code{new()}}{
Initialise Async Notion Client
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncNotionClient$new(
  auth = NULL,
  base_url = "https://api.notion.com/v1/",
  version = getOption("notionapi.version"),
  timeout = 60000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{auth}}{Authentication token. Uses NOTION_TOKEN environment variable by default.}

\item{\code{base_url}}{Character. Base URL for Notion API.}

\item{\code{version}}{Character. Notion API version.}

\item{\code{timeout}}{Numeric. Number of milliseconds to wait before timing out a request.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncNotionClient-request"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncNotionClient-request}{}}}
\subsection{Method \code{request()}}{
Create a base \code{httr2} request object for the Notion API.

This method is primarily for advanced users who want to make custom API calls
or for debugging purposes. Most users should use the endpoint methods instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncNotionClient$request()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
httr2 request object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncNotionClient-print"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncNotionClient-print}{}}}
\subsection{Method \code{print()}}{
Print basic details of Notion Client
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncNotionClient$print()}\if{html}{\out{</div>}}
}

}
}
