% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbouch.R
\name{elbouch.test}
\alias{elbouch.test}
\title{Computes El Bouch, et al.'s test for normality of multivariate dependent samples.}
\usage{
elbouch.test(y, x = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{x}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}
}
\value{
A list with class \code{"h.test"} containing the following components:
 \item{statistic:}{the El Bouch Z statistic.}
 \item{p.value:}{the p value for the test.}
 \item{alternative:}{a character string describing the alternative hypothesis.}
 \item{method:}{a character string \dQuote{El Bouch, Michel & Comon's test}.}
 \item{data.name:}{a character string giving the name of the data.}
}
\description{
Computes the El Bouch, Michel, & Comon's  test for normality of a bivariate dependent samples.
}
\details{
This function computes El Bouch, et al. (2022) test for normality of
bivariate dependent samples. If `x` is set to `NULL`, the test computes the univariate
counterpart. This test is a correction of Mardia's, (1970) multivariate skewness
and kurtosis test for multivariate samples.
}
\examples{
# Generate an univariate stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
elbouch.test(y)

# Generate a bivariate Gaussian random vector
x = rnorm(200)
y = rnorm(200)
elbouch.test(y = y, x = x)

}
\references{
El Bouch, S., Michel, O. & Comon, P.  (2022). A normality test for Multivariate dependent
samples. \emph{Journal of Signal Processing}. Volume 201.

Mardia, K. (1970). Measures of multivariate skewness and kurtosis with applications.
\emph{Biometrika}, 57 519-530

Lobato, I., & Velasco, C. (2004). A simple test of normality in time series.
\emph{Journal of econometric theory}. 20(4), 671-689.
}
\seealso{
\code{\link{lobato.test}}
}
\author{
Asael Alonzo Matamoros.
}
