% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pielou_evenness.R
\name{pielou_evenness}
\alias{pielou_evenness}
\title{Pielou's Evenness for Nominal Variables}
\usage{
pielou_evenness(df, var)
}
\arguments{
\item{df}{A data.frame or tibble containing the nominal variable.}

\item{var}{Character string giving the name of the nominal variable in \code{df}.}
}
\value{
A numeric value representing Pielou's evenness.
}
\description{
Computes Pielou's evenness index based on Shannon entropy for a
nominal variable recorded as individual-level observations.
}
\details{
Pielou's evenness is defined as:
\deqn{E = H / \log(S)}
where \eqn{H} is Shannon entropy and \eqn{S} is the number of observed categories.

Values range from 0 (complete dominance by one category)
to 1 (perfectly even distribution).
}
\examples{
pielou_evenness(categories, "animal")
pielou_evenness(categories2, "animal")
pielou_evenness(categories3, "animal")

}
