### Testing function for confidence intervals
require(ggplot2)
require(nlraa)
require(nlme)

### Testing objects of class 'lm'
if(FALSE){
  set.seed(123)
  x <- 1:30
  y <- linp(x, 0, 1, 20) + rnorm(30, 0, 0.5)
  dat <- data.frame(x = x, y = y)
  fit.lm <- lm(y ~ x + I(x^2), data = dat)
  
  cfs.int <- confidence_intervals(fit.lm)
  cfs.int <- confidence_intervals(fit.lm, method = c("wald", "bootstrap"))
  
  ggplot(data = cfs.int) + 
    facet_wrap(~ parm, scales = "free") + 
    geom_point(aes(x = method, y = lower)) + 
    geom_point(aes(x = method, y = estimate), color = "red") + 
    geom_point(aes(x = method, y = upper)) + 
    ylab("Parameter values")
  
  #### Fitting objects of class 'nls'
  fit.nls <- nls(y ~ SSlinp(x, a, b, xs), data = dat)
  
  cfs.int <- confidence_intervals(fit.nls)
  cfs.int <- confidence_intervals(fit.nls, method = c("wald", "profile", "bootstrap"))
  
  ggplot(data = cfs.int) + 
    facet_wrap(~ parm, scales = "free") + 
    geom_point(aes(x = method, y = lower)) + 
    geom_point(aes(x = method, y = estimate), color = "red") + 
    geom_point(aes(x = method, y = upper)) + 
    ylab("Parameter values")
  
  data(barley, package = "nlraa")
  ## Fit a linear model (quadratic)
  fit.lm <- lm(yield ~ NF + I(NF^2), data = barley)
  
  cfs.int <- confidence_intervals(fit.lm, method = c("wald", "bootstrap"))
  
  fit.nls <- nls(yield ~ SSlinp(NF, a, b, xs), data = barley)
  
  cfs.int2 <- confidence_intervals(fit.nls, 
                                   R = 2e3,
                                   method = c("wald", "profile", "bootstrap"))
  
  ggplot(data = cfs.int2) + 
    facet_wrap(~ parm, scales = "free") + 
    geom_point(aes(x = method, y = lower)) + 
    geom_point(aes(x = method, y = estimate), color = "red") + 
    geom_point(aes(x = method, y = upper)) + 
    ylab("Parameter values")
  
  fit.gls <- gls(follicles ~ sin(2*pi*Time) + cos(2*pi*Time), Ovary,
                 correlation = corAR1(form = ~ 1 | Mare))     
  
  cfs.int3 <- confidence_intervals(fit.gls, 
                                   R = 2e3,
                                   method = c("wald", "bootstrap"))
  
  ggplot(data = cfs.int3) + 
    facet_wrap(~ parm, scales = "free") + 
    geom_point(aes(x = method, y = lower)) + 
    geom_point(aes(x = method, y = estimate), color = "red") + 
    geom_point(aes(x = method, y = upper)) + 
    ylab("Parameter values")
  
  fit.gnls <- gnls(weight ~ SSlogis(Time, Asym, xmid, scal), Soybean,
                   weights = varPower())
  
  cfs.int4 <- confidence_intervals(fit.gnls, 
                                   R = 2e3,
                                   method = c("wald", "bootstrap"))
  
  cfs.int4 <- confidence_intervals(fit.gnls, 
                                   R = 2e3,
                                   method = "all")
  
  ggplot(data = cfs.int4) + 
    facet_wrap(~ parm, scales = "free") + 
    geom_point(aes(x = method, y = lower)) + 
    geom_point(aes(x = method, y = estimate), color = "red") + 
    geom_point(aes(x = method, y = upper)) + 
    ylab("Parameter values")
  
  ### Testing lme
  fit.lme <- lme(distance ~ age, data = Orthodont)
  
  cfs.int5 <- confidence_intervals(fit.lme, 
                                   R = 2e3,
                                   method = "all")
  
  ggplot(data = cfs.int5) + 
    facet_wrap(~ parm, scales = "free") + 
    geom_point(aes(x = method, y = lower)) + 
    geom_point(aes(x = method, y = estimate), color = "red") + 
    geom_point(aes(x = method, y = upper)) + 
    ylab("Parameter values")
  
  fit.nlme <- nlme(height ~ SSasymp(age, Asym, R0, lrc),
                   data = Loblolly,
                   fixed = Asym + R0 + lrc ~ 1,
                   random = Asym ~ 1,
                   start = c(Asym = 103, R0 = -8.5, lrc = -3.3))
  
  cfs.int6 <- confidence_intervals(fit.nlme, 
                                   R = 2e3,
                                   method = "all")
  
  ggplot(data = cfs.int6) + 
    facet_wrap(~ parm, scales = "free") + 
    geom_point(aes(x = method, y = lower)) + 
    geom_point(aes(x = method, y = estimate), color = "red") + 
    geom_point(aes(x = method, y = upper)) + 
    ylab("Parameter values")  
}

