% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSpquad3.R
\name{SSpquad3}
\alias{SSpquad3}
\alias{pquad3}
\title{self start for plateau-quadratic function}
\usage{
pquad3(x, a, b, c)

SSpquad3(x, a, b, c)
}
\arguments{
\item{x}{input vector}

\item{a}{the intercept}

\item{b}{the slope}

\item{c}{quadratic term}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

quadp: vector of the same length as x using the quadratic-plateau function
}
\description{
Self starter for plateau-quadratic function with (three) parameters a (intercept), b (slope), c (quadratic)
}
\details{
Reference for nonlinear regression Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506).
}
\examples{
\donttest{
require(ggplot2)
require(minpack.lm)
set.seed(123)
x <- 1:30
y <- pquad3(x, 20.5, 0.36, -0.012) + rnorm(30, 0, 0.3)
dat <- data.frame(x = x, y = y)
fit <- nlsLM(y ~ SSpquad3(x, a, b, c), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
