% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{ranger_wrapper}
\alias{ranger_wrapper}
\title{Wrapper for fitting a random forest using \link[ranger]{ranger}.}
\usage{
ranger_wrapper(
  train,
  test,
  num.trees = 500,
  mtry = floor(sqrt(ncol(train$X))),
  write.forest = TRUE,
  probability = TRUE,
  min.node.size = 5,
  replace = TRUE,
  sample.fraction = ifelse(replace, 1, 0.632),
  num.threads = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{train}{A list with named objects \code{Y} and \code{X} (see description).}

\item{test}{A list with named objects \code{Y} and \code{X} (see description).}

\item{num.trees}{See \link[ranger]{ranger}.}

\item{mtry}{See \link[ranger]{ranger}.}

\item{write.forest}{See \link[ranger]{ranger}.}

\item{probability}{See \link[ranger]{ranger}.}

\item{min.node.size}{See \link[ranger]{ranger}.}

\item{replace}{See \link[ranger]{ranger}.}

\item{sample.fraction}{See \link[ranger]{ranger}.}

\item{num.threads}{See \link[ranger]{ranger}.}

\item{verbose}{See \link[ranger]{ranger}.}

\item{...}{Other options (passed to \code{ranger})}
}
\value{
A list with named objects (see description).
}
\description{
Compatible learner wrappers for this package should have a specific format.
Namely they should take as input a list called \code{train} that contains
named objects \code{$Y} and \code{$X}, that contain, respectively, the outcomes
and predictors in a particular training fold. Other options may be passed in
to the function as well. The function must output a list with the following
named objects: \code{test_pred} = predictions of \code{test$Y} based on the learner
fit using \code{train$X}; \code{train_pred} = prediction of \code{train$Y} based 
on the learner fit using \code{train$X}; \code{model} = the fitted model (only 
necessary if you desire to look at this model later, not used for internal 
computations); \code{train_y} = a copy of \code{train$Y}; \code{test_y} = a copy
of \code{test$Y}.
}
\details{
This particular wrapper implements the \link[ranger]{ranger} ensemble
methodology. We refer readers to the original package's documentation for more
details.
}
\examples{
# simulate data
# make list of training data
train_X <- data.frame(x1 = runif(50))
train_Y <- rbinom(50, 1, plogis(train_X$x1))
train <- list(Y = train_Y, X = train_X)
# make list of test data
test_X <- data.frame(x1 = runif(50))
test_Y <- rbinom(50, 1, plogis(train_X$x1))
test <- list(Y = test_Y, X = test_X)
# fit ranger
rf_wrap <- ranger_wrapper(train = train, test = test)
}
