% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDirect.R
\name{addDirectLin}
\alias{addDirectLin}
\title{Add direct linear effect with baseline=0}
\usage{
addDirectLin(ui, ek = "Ek", cc = c("Ce", "Cc"), effect = "effect")
}
\arguments{
\item{ui}{rxode2 model}

\item{ek}{simulation linear constant}

\item{cc}{the concentration value}

\item{effect}{the effect variable that will be modeled}
}
\value{
model with direct linear effect added (baseline=0)
}
\description{
Add direct linear effect with baseline=0
}
\examples{


# Direct linear model
readModelDb("PK_2cmt_no_depot") |>
  addDirectLin()

# Direct emax model
readModelDb("PK_2cmt_no_depot") |>
  addDirectLin() |>
  convertEmax()

}
\seealso{
Other PD: 
\code{\link{addBaseline1exp}()},
\code{\link{addBaselineConst}()},
\code{\link{addBaselineExp}()},
\code{\link{addBaselineLin}()},
\code{\link{convertEmax}()},
\code{\link{convertLogLin}()},
\code{\link{convertQuad}()}
}
\author{
Matthew L. Fidler
}
\concept{PD}
