% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimbleFunction_Rexecution.R
\name{nimMatrix}
\alias{nimMatrix}
\alias{nimArray}
\alias{matrix}
\alias{array}
\title{Creates matrix or array objects for use in nimbleFunctions}
\usage{
nimMatrix(
  value = 0,
  nrow = NA,
  ncol = NA,
  init = TRUE,
  fillZeros = TRUE,
  recycle = TRUE,
  type = "double"
)

nimArray(
  value = 0,
  dim = c(1, 1),
  init = TRUE,
  fillZeros = TRUE,
  recycle = TRUE,
  nDim,
  type = "double"
)
}
\arguments{
\item{value}{value(s) for initialization (default = 0).  This can be a vector, matrix or array, but it will be used as a vector.}

\item{nrow}{the number of rows in a matrix (default = 1)}

\item{ncol}{the number of columns in a matrix (default = 1)}

\item{init}{logical, whether to initialize values (default = \code{TRUE})}

\item{fillZeros}{logical, whether to initialize any elements not filled by (possibly recycled) \code{value} with 0 (or \code{FALSE} for \code{nimLogical}) (default = \code{TRUE})}

\item{recycle}{logical, whether \code{value} should be recycled to fill the entire contents of the new object (default = \code{TRUE})}

\item{type}{character representing the data type, i.e. \code{'double'}, \code{'integer'}, or \code{'logical'} (default = \code{'double'})}

\item{dim}{vector of dimension sizes in an array (default = \code{c(1, 1)})}

\item{nDim}{number of dimensions in an array.  This is only necessary for \code{compileNimble} if the length of \code{dim} cannot be determined during compilation.}
}
\description{
In a \code{nimbleFunction}, \code{matrix} and \code{array} are identical to \code{nimMatrix} and \code{nimArray}, respectively
}
\details{
These functions are similar to R's \code{\link{matrix}} and \code{\link{array}} functions, but they can be used in a nimbleFunction and compiled using \code{compileNimble}.  Largely for compilation purposes, finer control is provided over initialization behavior, similarly to \code{\link{nimNumeric}}, \code{\link{nimInteger}}, and \code{\link{nimLogical}}. If \code{init = FALSE}, no initialization will be done, and \code{value}, \code{fillZeros} and \code{recycle} will be ignored.  If \code{init=TRUE} and \code{recycle=TRUE}, then \code{fillZeros} will be ignored, and \code{value} will be repeated (according to R's recycling rule) as much as necessary to fill the object.  If \code{init=TRUE} and \code{recycle=FALSE}, then if \code{fillZeros=TRUE}, values of 0 (or FALSE for \code{nimLogical}) will be filled in after \code{value}.  Compiled code will be more efficient if unnecessary initialization is not done, but this may or may not be noticeable depending on the situation.

When used in a \code{nimbleFunction} (in \code{run} or other member function), \code{matrix} and \code{array} are immediately converted to \code{nimMatrix} and \code{nimArray}, respectively.

The \code{nDim} argument is only necessary for a use like \code{dim <- c(2, 3, 4); A <- nimArray(0, dim = dim, nDim = 3)}.  It is necessary because the NIMBLE compiler must determine during compilation that \code{A} will be a 3-dimensional numeric array.  However, the compiler doesn't know for sure what the length of \code{dim} will be at run time, only that it is a vector.  On the other hand,   \code{A <- nimArray(0, dim = c(2, 3, 4))} is allowed because the compiler can directly determine that a vector of length three is constructed inline for the \code{dim} argument.
}
\seealso{
\code{\link{nimNumeric}} \code{\link{nimInteger}} \code{\link{nimLogical}}
}
\author{
Daniel Turek and Perry de Valpine
}
